/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.modules.sceNet;
import jpcsp.network.protocols.IPv4;
import jpcsp.network.protocols.NetPacket;
import jpcsp.network.protocols.UDP;
import jpcsp.util.Utilities;

public class DHCP {
    public static final byte[] nullIPAddress = new byte[]{0, 0, 0, 0};
    public static final byte[] broadcastIPAddress = new byte[]{-1, -1, -1, -1};
    public static final int DHCP_BOOT_REQUEST = 1;
    public static final int DHCP_BOOT_REPLY = 2;
    public static final int DHCP_OPTION_MAGIC_COOKIE = 1669485411;
    public static final int DHCP_OPTION_PAD = 0;
    public static final int DHCP_OPTION_SUBNET_MASK = 1;
    public static final int DHCP_OPTION_ROUTER = 3;
    public static final int DHCP_OPTION_DNS = 6;
    public static final int DHCP_OPTION_DOMAIN_NAME = 15;
    public static final int DHCP_OPTION_BROADCAST_ADDRESS = 28;
    public static final int DHCP_OPTION_REQUESTED_IP_ADDRESS = 50;
    public static final int DHCP_OPTION_IP_ADDRESS_LEASE_TIME = 51;
    public static final int DHCP_OPTION_MESSAGE_TYPE = 53;
    public static final int DHCP_OPTION_SERVER_IDENTIFIER = 54;
    public static final int DHCP_OPTION_PARAMETER_REQUEST = 55;
    public static final int DHCP_OPTION_MESSAGE = 56;
    public static final int DHCP_OPTION_MAXIMUM_DHCP_MESSAGE = 57;
    public static final int DHCP_OPTION_CLIENT_IDENTIFIER = 61;
    public static final int DHCP_OPTION_END = 255;
    public static final String[] DHCP_OPTION_NAMES = new String[256];
    public static final int DHCP_OPTION_MESSAGE_TYPE_DHCPDISCOVER = 1;
    public static final int DHCP_OPTION_MESSAGE_TYPE_DHCPOFFER = 2;
    public static final int DHCP_OPTION_MESSAGE_TYPE_DHCPREQUEST = 3;
    public static final int DHCP_OPTION_MESSAGE_TYPE_DHCPDECLINE = 4;
    public static final int DHCP_OPTION_MESSAGE_TYPE_DHCPACK = 5;
    public static final int DHCP_OPTION_MESSAGE_TYPE_DHCPNAK = 6;
    public static final int DHCP_OPTION_MESSAGE_TYPE_DHCPRELEASE = 7;
    public int opcode;
    public int hardwareAddressType;
    public int hardwareAddressLength;
    public int hops;
    public int transactionID;
    public int seconds;
    public boolean flagBroadcast;
    public int flagsZero;
    public byte[] clientIPAddress;
    public byte[] yourIPAddress;
    public byte[] nextServerIPAddress;
    public byte[] relayAgentIPAddress;
    public byte[] clientHardwareAddress;
    public String serverHostName;
    public String bootFileName;
    public List<DHCPOption> options;

    public DHCP() {
        this.options = new LinkedList<DHCPOption>();
    }

    public DHCP(DHCP dhcp) {
        this.opcode = dhcp.opcode;
        this.hardwareAddressType = dhcp.hardwareAddressType;
        this.hardwareAddressLength = dhcp.hardwareAddressLength;
        this.hops = dhcp.hops;
        this.transactionID = dhcp.transactionID;
        this.seconds = dhcp.seconds;
        this.flagBroadcast = dhcp.flagBroadcast;
        this.flagsZero = dhcp.flagsZero;
        this.clientIPAddress = dhcp.clientIPAddress;
        this.yourIPAddress = dhcp.yourIPAddress;
        this.nextServerIPAddress = dhcp.nextServerIPAddress;
        this.relayAgentIPAddress = dhcp.relayAgentIPAddress;
        this.clientHardwareAddress = dhcp.clientHardwareAddress;
        this.serverHostName = dhcp.serverHostName;
        this.bootFileName = dhcp.bootFileName;
        this.options = dhcp.options;
    }

    public void read(NetPacket packet) throws EOFException {
        this.opcode = packet.read8();
        this.hardwareAddressType = packet.read8();
        this.hardwareAddressLength = packet.read8();
        this.hops = packet.read8();
        this.transactionID = packet.read32();
        this.seconds = packet.read16();
        this.flagBroadcast = packet.readBoolean();
        this.flagsZero = packet.readBits(15);
        this.clientIPAddress = packet.readBytes(4);
        this.yourIPAddress = packet.readBytes(4);
        this.nextServerIPAddress = packet.readBytes(4);
        this.relayAgentIPAddress = packet.readBytes(4);
        this.clientHardwareAddress = packet.readBytes(16);
        this.serverHostName = packet.readStringNZ(64);
        this.bootFileName = packet.readStringNZ(128);
        int optionsLength = 312;
        int magicCookie = packet.read32();
        optionsLength -= 4;
        if (magicCookie == 1669485411) {
            while (optionsLength > 0) {
                DHCPOption option = new DHCPOption();
                option.read(packet);
                this.options.add(option);
                optionsLength -= option.sizeOf();
                if (option.tag != 255) continue;
                break;
            }
        } else {
            packet.skip8(optionsLength);
        }
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.write8(this.opcode);
        packet.write8(this.hardwareAddressType);
        packet.write8(this.hardwareAddressLength);
        packet.write8(this.hops);
        packet.write32(this.transactionID);
        packet.write16(this.seconds);
        packet.writeBoolean(this.flagBroadcast);
        packet.writeBits(this.flagsZero, 15);
        packet.writeBytes(this.clientIPAddress, 0, 4);
        packet.writeBytes(this.yourIPAddress, 0, 4);
        packet.writeBytes(this.nextServerIPAddress, 0, 4);
        packet.writeBytes(this.relayAgentIPAddress, 0, 4);
        packet.writeBytes(this.clientHardwareAddress, 0, 16);
        packet.writeStringNZ(this.serverHostName, 64);
        packet.writeStringNZ(this.bootFileName, 128);
        int optionsLength = 312;
        packet.write32(1669485411);
        optionsLength -= 4;
        for (DHCPOption option : this.options) {
            if (optionsLength < option.sizeOf()) break;
            option.write(packet);
        }
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(this.sizeOf()));
    }

    public int sizeOf() {
        return 548;
    }

    public boolean isMessageOfType(UDP udp, IPv4 ipv4, int messageType, boolean checkIp) {
        DHCPOption option;
        if (this.opcode != 1) {
            return false;
        }
        if (udp.sourcePort != 68 || udp.destinationPort != 67) {
            return false;
        }
        if (checkIp) {
            if (!Arrays.equals(ipv4.sourceIPAddress, nullIPAddress)) {
                return false;
            }
            if (!Arrays.equals(ipv4.destinationIPAddress, broadcastIPAddress)) {
                return false;
            }
        }
        if ((option = this.getOptionByTag(53)) == null || option.length != 1) {
            return false;
        }
        int optionMessageType = option.getDataAsInt();
        return optionMessageType == messageType;
    }

    public boolean isDiscovery(UDP udp, IPv4 ipv4) {
        return this.isMessageOfType(udp, ipv4, 1, true);
    }

    public boolean isRequest(UDP udp, IPv4 ipv4, byte[] requestedIpAddress) {
        if (!this.isMessageOfType(udp, ipv4, 3, true)) {
            return false;
        }
        DHCPOption requestedIpAddressOption = this.getOptionByTag(50);
        if (requestedIpAddressOption == null || requestedIpAddressOption.length != 4) {
            return false;
        }
        return Arrays.equals(requestedIpAddress, requestedIpAddressOption.data);
    }

    public boolean isRelease(UDP udp, IPv4 ipv4, byte[] releasedIpAddress) {
        if (!this.isMessageOfType(udp, ipv4, 7, false)) {
            return false;
        }
        return Arrays.equals(releasedIpAddress, ipv4.sourceIPAddress);
    }

    public void addOption(DHCPOption option) {
        this.options.add(option);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public DHCPOption getOptionByTag(int tag) {
        for (DHCPOption option : this.options) {
            if (option.tag != tag) continue;
            return option;
        }
        return null;
    }

    private String optionsToString() {
        StringBuilder s = new StringBuilder();
        for (DHCPOption option : this.options) {
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(option.toString());
        }
        return s.toString();
    }

    private String clientHardwareAddressToString() {
        if (this.hardwareAddressLength == 6) {
            return sceNet.convertMacAddressToString(this.clientHardwareAddress);
        }
        return Utilities.getMemoryDump(this.clientHardwareAddress, 0, this.hardwareAddressLength);
    }

    public String toString() {
        return String.format("opcode=0x%X, hardwareAddressType=0x%X, hardwareAddressLength=0x%X, hops=0x%X, transactionID=0x%08X, seconds=0x%X, flagBroadcast=%b, flags=0x%04X, clientIPAddress=%s, yourIPAddress=%s, nextServerIPAddress=%s, relayAgentIPAddress=%s, clientHardwareAddress=%s, serverHostName='%s', bootFileName='%s', options=%s", this.opcode, this.hardwareAddressType, this.hardwareAddressLength, this.hops, this.transactionID, this.seconds, this.flagBroadcast, this.flagsZero, NetPacket.getIpAddressString(this.clientIPAddress), NetPacket.getIpAddressString(this.yourIPAddress), NetPacket.getIpAddressString(this.nextServerIPAddress), NetPacket.getIpAddressString(this.relayAgentIPAddress), this.clientHardwareAddressToString(), this.serverHostName, this.bootFileName, this.optionsToString());
    }

    static {
        DHCP.DHCP_OPTION_NAMES[0] = "PAD";
        DHCP.DHCP_OPTION_NAMES[1] = "SUBNET_MASK";
        DHCP.DHCP_OPTION_NAMES[3] = "ROUTER";
        DHCP.DHCP_OPTION_NAMES[6] = "DNS";
        DHCP.DHCP_OPTION_NAMES[15] = "DOMAIN_NAME";
        DHCP.DHCP_OPTION_NAMES[28] = "BROADCAST_ADDRESS";
        DHCP.DHCP_OPTION_NAMES[50] = "REQUESTED_IP_ADDRESS";
        DHCP.DHCP_OPTION_NAMES[51] = "IP_ADDRESS_LEASE_TIME";
        DHCP.DHCP_OPTION_NAMES[53] = "MESSAGE_TYPE";
        DHCP.DHCP_OPTION_NAMES[54] = "SERVER_IDENTIFIER";
        DHCP.DHCP_OPTION_NAMES[55] = "PARAMETER_REQUEST";
        DHCP.DHCP_OPTION_NAMES[56] = "MESSAGE";
        DHCP.DHCP_OPTION_NAMES[57] = "MAXIMUM_DHCP_MESSAGE";
        DHCP.DHCP_OPTION_NAMES[61] = "CLIENT_IDENTIFIER";
        DHCP.DHCP_OPTION_NAMES[255] = "END";
    }

    public static class DHCPOption {
        int tag;
        int length;
        byte[] data;

        public DHCPOption() {
            this.tag = 255;
        }

        public DHCPOption(int tag) {
            this.tag = tag;
        }

        public DHCPOption(int tag, byte data) {
            this.tag = tag;
            this.length = 1;
            this.data = new byte[]{data};
        }

        public DHCPOption(int tag, int data) {
            this.tag = tag;
            this.length = 4;
            this.data = new byte[4];
            this.data[0] = (byte)(data >> 24);
            this.data[1] = (byte)(data >> 16);
            this.data[2] = (byte)(data >> 8);
            this.data[3] = (byte)data;
        }

        public DHCPOption(int tag, byte[] data) {
            this.tag = tag;
            this.length = data == null ? 0 : data.length;
            this.data = data;
        }

        public void read(NetPacket packet) throws EOFException {
            this.tag = packet.read8();
            if (!this.isZeroLengthTag()) {
                this.length = packet.read8();
                this.data = packet.readBytes(this.length);
            }
        }

        private boolean isZeroLengthTag() {
            return this.tag == 0 || this.tag == 255;
        }

        public int sizeOf() {
            if (this.isZeroLengthTag()) {
                return 1;
            }
            return 2 + this.length;
        }

        public NetPacket write(NetPacket packet) throws EOFException {
            packet.write8(this.tag);
            if (!this.isZeroLengthTag()) {
                packet.write8(this.length);
                packet.writeBytes(this.data, 0, this.length);
            }
            return packet;
        }

        public int getDataAsInt() {
            int value = 0;
            switch (this.length) {
                case 1: {
                    value = this.data[0] & 0xFF;
                    break;
                }
                case 2: {
                    value = (this.data[0] & 0xFF) << 8;
                    value |= this.data[1] & 0xFF;
                    break;
                }
                case 4: {
                    value = (this.data[0] & 0xFF) << 24;
                    value |= (this.data[1] & 0xFF) << 16;
                    value |= (this.data[2] & 0xFF) << 8;
                    value |= this.data[3] & 0xFF;
                }
            }
            return value;
        }

        private String getTagName() {
            if (this.tag >= 0 && this.tag < DHCP_OPTION_NAMES.length && DHCP_OPTION_NAMES[this.tag] != null) {
                return DHCP_OPTION_NAMES[this.tag];
            }
            return String.format("tag=%d", this.tag);
        }

        public String toString() {
            if (this.isZeroLengthTag()) {
                return this.getTagName();
            }
            String dataString = this.length == 1 || this.length == 2 || this.length == 4 ? String.format("0x%X", this.getDataAsInt()) : Utilities.getMemoryDump(this.data, 0, this.length);
            return String.format("%s(length=0x%X, data=%s)", this.getTagName(), this.length, dataString);
        }
    }
}

